#version 450 compatibility


#define IS_NETHER

layout(location = 0) out vec4 specTex;
layout(location = 1) out vec3 sceneData;

//uniform vec3 fogColor;
uniform float BiomeNetherWastesSmooth;
uniform float BiomeWarpedForestSmooth;
uniform float BiomeCrimsonForestSmooth;
uniform float BiomeSoulSandValleySmooth;
uniform float BiomeBasaltDeltasSmooth;

in vec2 texcoord;

flat in vec3 colorTorchlight;

//in vec3 worldLightVector;
//in vec3 worldSunVector;

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Functions.inc"

/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Material.inc"

#include "/lib/Head/Mask.inc"

/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

vec3 NetherLightingColor() {
	vec3 color = BiomeNetherWastesSmooth   * vec3(0.99, 0.34, 0.1) * 0.9;
	color +=	 BiomeWarpedForestSmooth   * vec3(0.79, 0.82, 1.0) * 0.5;
	color +=	 BiomeCrimsonForestSmooth  * vec3(1.0, 0.80, 0.57);
	color +=	 BiomeSoulSandValleySmooth * vec3(0.6, 0.77, 1.0)  * 0.35;
	color +=	 BiomeBasaltDeltasSmooth   * vec3(1.0, 0.78, 0.62) * 2.0;
	return color;
}

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	ivec2 texel = ivec2(gl_FragCoord.xy);

	float depth = GetDepthT(texel);

	if (depth < 1.0) {
		vec3 albedoRaw = texelFetch(colortex6, texel, 0).rgb;
		vec3 albedo = SRGBtoLinear(albedoRaw);

		vec4 gbuffer3 = texelFetch(colortex3, texel, 0);

		int materialID = int(texelFetch(colortex7, texel, 0).z * 255.0);
		//int materialIDT = int(texelFetch(colortex1, texel, 0).b * 255.0);

		//MaterialMask materialMask = CalculateMasks(materialID);
		//TranslucentMask materialMaskT = CalculateMasksT(materialIDT);

		vec3 viewPos  = ScreenToViewSpace(vec3(texcoord, depth));
	
		vec3 worldPos = mat3(gbufferModelViewInverse) * viewPos;
		vec3 worldDir = normalize(worldPos);
		worldPos += gbufferModelViewInverse[3].xyz;

		vec2 mcLightmap = texelFetch(colortex7, texel, 0).rg;
		mcLightmap.g = cube(mcLightmap.g);

		vec3 normal = DecodeNormal(gbuffer3.xy);
		vec3 worldNormal = mat3(gbufferModelViewInverse) * normal;

		specTex = vec4(UnpackUnorm2x8(gbuffer3.z), UnpackUnorm2x8(gbuffer3.w));
		Material material = GetMaterialData(specTex);
		specTex.x = sqr(1.0 - specTex.x);

		// Grass points up
		if (materialID == 6 || materialID == 27 || materialID == 28 || materialID == 33) worldNormal = vec3(0.0, 1.0, 0.0);

		float NdotV = saturate(dot(worldNormal, -worldDir));

		// Basic light
		sceneData = (BASIC_BRIGHTNESS_NETHER + nightVision * 0.2) * 3.0 * NetherLightingColor();

		// AO
		#ifdef SSAO_ENABLED
			float ao = texelFetch(colortex0, texel / 2, 0).a;
			sceneData *= ao;
		#else
			float ao = 1.0;
		#endif

		//torchlight
		#include "/lib/Lighting/BlockLighting.glsl"

		sceneData *= albedo;
		sceneData *= oneMinus(material.isMetal * 0.8);
	}

	sceneData = clamp16F(sceneData);
}

/* DRAWBUFFERS:04 */